﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using System.Diagnostics;
using System.IO;


namespace 電子文書回覧追跡ツール
{
    public partial class 検索Form : Form
    {
        public 検索Form(Form1 caller, string topPath, string searchString, bool searchlevel)
        {
            InitializeComponent();
            this.listBox1.Items.Clear();
            this.caller = caller;
            this.toppath = topPath;
            this.searchString = searchString;
            this.サーチレベル = searchlevel;
        }
        Form1 caller;
        string toppath;
        string searchString;
        bool サーチレベル;

        private void 閉じる_Click(object sender, EventArgs e)
        {
            this.Dispose();
        }

        private void 検索Form_Load(object sender, EventArgs e)
        {
            this.Text = "検索中";
            label1.Text = "検索中です．．．．．";
        }

        private void 検索Form_Shown(object sender, EventArgs e)
        {
            search(toppath, searchString, サーチレベル);

        }
        public void search(string toppath, string searchString, bool isMoreLevel)
        //searchlevel 0=通常レベルまでサーチ 1=一つ下のレベルまでサーチ
        {
            btn中断.Visible = true;
            btn中断.Focus();
            listBox1.Items.Clear();
            bool exist = false;
            Queue<string> q = new Queue<string>();
            q.Enqueue(toppath);
            while (q.Count > 0)
            {
                if(中断) break;
                string d = (string)q.Dequeue();
                bool accessOK = true;
                string[] dirs = null;
                try
                {
                    dirs = System.IO.Directory.GetDirectories(d.Replace("|more|", ""));//エラーとなる可能性のある場所
                }catch{
                    accessOK = false;
                    MessageBox.Show("以下のフォルダはアクセスエラーとなります。ＯＫを答え飛ばして検索を進めて下さい。" + Environment.NewLine + d.Replace("|more|", ""));
                }
                if (accessOK)
                {
                    foreach (string s in dirs)
                    {
                        if (中断) break;
                        if (s.Substring(s.LastIndexOf("\\") + 1).ToUpper().Contains(searchString.ToUpper()))
                        {
                            //有り
                            listBox1.Items.Add(s);
                            listBox1.Refresh();
                            exist = true;
                        }
                        else
                        {
                            //無し
                            Application.DoEvents();
                            if (d.StartsWith("|more|"))
                            {
                                //一段下を見たのでもう良い
                            }
                            else
                            {
                                if (Regex.IsMatch(s.Substring(s.LastIndexOf("\\") + 1), "^[0-9]{1,2}_") || s.Substring(s.LastIndexOf("\\") + 1).Contains("!") || s.Substring(s.LastIndexOf("\\") + 1).Contains("！"))
                                {
                                    //格納フォルダなので見る
                                    q.Enqueue(s);
                                }
                                else
                                {
                                    //文書フォルダだ
                                    if (isMoreLevel)
                                    {
                                        //一段下を見る
                                        q.Enqueue("|more|" + s);
                                    }
                                }
                            }
                        }
                    }
                    dirs = System.IO.Directory.GetFiles(d.Replace("|more|", ""));
                    foreach (string s in dirs)
                    {
                        if(中断) break;
                        if(s.Substring(s.LastIndexOf("\\") + 1).ToUpper().Contains(searchString.ToUpper()))
                        {
                            //有り
                            if(!d.Contains("|more|")){
                                if(Path.GetExtension(s) == ".lnk") {//一段目のショートカットは除く
                                    continue;
                                }
                            }
                            listBox1.Items.Add(s);
                            listBox1.Refresh();
                            exist = true;
                        }
                    }
                }
            }
            if (exist)
            {
                this.Text = "検索結果";
                if (中断)
                {
                    label1.Text = "中断しました。検索結果から文書名取込、または開く事が出来ます";
                }
                else
                {
                    label1.Text = "以上の検索結果から文書名取込、または開く事が出来ます";
                }
                btn取込.Visible = true;
                btn開く.Visible = true;
                btn取込.Focus();
                
            }
            else
            {
                this.Text = "検索結果";
                label1.Text = "見つかりませんでした";
                btn取込.Visible = false;
                btn開く.Visible = false;
                btn中止.Focus();
            }
            btn中断.Visible = false;
            //caller.enable検索ボタン();
        }

        private void btn取込_Click(object sender, EventArgs e)
        {
            if (listBox1.SelectedItem != null)
            {
                //選択あり
                caller.docname = get文書名(listBox1.SelectedItem.ToString());
                this.Dispose();
            }
            else
            {
                //選択されてない
                if (listBox1.Items.Count == 1)
                {
                    //１つしか無い
                    listBox1.SetSelected(0, true);//先頭を選択する
                    caller.docname = get文書名(listBox1.SelectedItem.ToString());
                    this.Dispose();
                }
                else
                {
                    //複数ある
                    MessageBox.Show("行を一つセレクトして下さい");
                }
            }
        }

        private void btn開く_Click(object sender, EventArgs e)
        {
            if (listBox1.SelectedItem != null)
            {
                string path = get文書パス(listBox1.SelectedItem.ToString());
                if(caller.untouchableFolder != "" && path.Contains(caller.untouchableFolder)) {
                    path = (new untoutchable()).untouchableFolderCopy(path);
                }
                if(path != ""){
                    openfolder(path);
                }
            }
            else
            {
                if (listBox1.Items.Count == 1)
                {
                    listBox1.SetSelected(0, true);
                    string path = get文書パス(listBox1.SelectedItem.ToString());
                    if(caller.untouchableFolder != "" && path.Contains(caller.untouchableFolder)) {
                        path = (new untoutchable()).untouchableFolderCopy(path);
                    }
                    if(path != "") {
                        openfolder(path);
                    }
                }
                else
                {
                    MessageBox.Show("行を一つセレクトして下さい");
                }
            }
        }

        //格納フォルダの直下を得る
        private string get文書名(string path)
        {
            string underTopPath = path.Substring(toppath.Length);
            foreach(string str in underTopPath.Split(new char[] { '\\' }, StringSplitOptions.RemoveEmptyEntries)) {
                if(Regex.IsMatch(str, "^([0-9]{1,2}_|!|！)")) {
                    continue;
                }
                else {
                    return str;
                }
            }
            MessageBox.Show("このフォルダの形態は追跡に適さない、整備されていないものです。 " + " underTopPath=" + underTopPath);
            return "";
        }

        //  格納フォルダの下以降を得る
        private string get文書パス(string path) {
            string underTopPath = path.Substring(toppath.Length);
            string[] strs = underTopPath.Split(new char[] { '\\' }, StringSplitOptions.RemoveEmptyEntries);
            for(int i = 0; i < strs.Length; i++ ) {
                if(Regex.IsMatch(strs[i], "^([0-9]{1,2}_|!|！)")) {
                    continue;
                }
                else {
                    StringBuilder sb = new StringBuilder(toppath);
                    for(int j = 0; j <= i; j++) {
                        sb.Append("\\");
                        sb.Append(strs[j]);
                    }
                    return sb.ToString();
                }
            }
            MessageBox.Show("このフォルダの形態は追跡に適さない整備されていないものです。 " + " underTopPath=" + underTopPath);
            return "";
        }

        private void openfolder(string path)
        {
            Process ex = new Process();
            ex.StartInfo.FileName = path;  //Explorer
            try
            {
                ex.Start(); //プロセス起動
            }
            catch (System.ComponentModel.Win32Exception)
            {
                MessageBox.Show("開けません");
            }
            catch (Exception exa)
            {
                MessageBox.Show(exa.Message);
            }
        }

        private void listBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            btn取込.Focus();
        }

        private void 中断_Click(object sender, EventArgs e)
        {
            中断 = true;
        }
        bool 中断 = false;

    }
}